### 25.5. 自定义日志配置

通过将适当的库添加到classpath，可以激活各种日志系统。然后在classpath的根目录(root)或通过Spring Environment的`logging.config`属性指定的位置提供一个合适的配置文件来达到进一步的定制（注意由于日志是在ApplicationContext被创建之前初始化的，所以不可能在Spring的@Configuration文件中，通过@PropertySources控制日志。系统属性和平常的Spring Boot外部配置文件能正常工作）。

根据你的日志系统，下面的文件会被加载：

| 日志系统        | 定制   |
| --------   | :-----:  | 
|Logback|logback.xml|
|Log4j|log4j.properties或log4j.xml|
|Log4j2|log4j2.xml|
|JDK (Java Util Logging)|logging.properties|

为了帮助定制一些其他的属性，从Spring的Envrionment转换到系统属性：

| Spring Environment| System Property| 评价 |
| --------   | :-----:  | :----:  |
|logging.file|LOG_FILE|如果定义，在默认的日志配置中使用|
|logging.path|LOG_PATH|如果定义，在默认的日志配置中使用|
|PID|PID|当前的处理进程(process)ID（如果能够被发现且还没有作为操作系统环境变量被定义）|

所有支持的日志系统在解析它们的配置文件时都能查询系统属性。具体可以参考spring-boot.jar中的默认配置。

**注**：在运行可执行的jar时，Java Util Logging有类加载问题，我们建议你尽可能避免使用它。
